*****************************************************
// IV - Per capita health expenditure
*****************************************************
*Set polynomial order for each bandwidth
global apisbw2 
global apisbw5 X1
global apisbw10 X1 X2

global dhsbw2 X1
global dhsbw5 X1 X2
global dhsbw10 X1 X2  
global dhsbw15 X1 X2 

*Texfile
global texfile "$output\table_iv"

global cluster age  // used in the boottest code
global controls   

global extrabandwidths // 2 3 4 6 7 8 9 11 12 13 14 // leave blank to skip graphs
global title_lnpchealth "A. Log Health Expenditures"
global title_healthshare "B. Health Expenditure Share"
global title_lnpcip "C. Log Inpatient Expenditures"
global title_lnpcop  "D. Log Outpatient Expenditures"
global title_lnpcdrug "E. Log Medical Product Expenditures"
global title_yconfined "F. Hospital Stay Last Year"
global title_mvisit  "G. Health Visit Last Month"
global title_mconfined "H. Hospital Stay Last Month"

*******************************************************************************
**APIS*************************************************************************
*******************************************************************************

* Estimate IV regression
*use "$data\apisallfile", clear
use "$data\apisfile", clear
* Create mock column
qui reg phicmem 
  est store fmock


global flist0 
cap matrix drop stats
cap g bw=_n
foreach yvar in  lnpchealth healthshare lnpcip lnpcop  lnpcdrug  {
	cap g b_`yvar'=.
	cap g ul_`yvar'=.
	cap g ll_`yvar'=.
	foreach b in  5 10 $extrabandwidths { 
	if `b' < 5 {
	local fX ${apisbw2}
	}
	
	if inrange(`b',5,9) {
	local fX ${apisbw5}			
	}
	if `b' >= 10 {
	local fX ${apisbw10}
	}	

	
				 ivreg2 `yvar' (phicmem = D_after) D i.year c.(`fX') i.D#c.(`fX') flagexp /*flagmed*/ $controls if inrange(X1, -`b', `b'-1) , /*partial($controls)*/ cluster(hhid) 
					replace b_`yvar'=_b[phicmem] if bw==`b'
					replace ul_`yvar'=_b[phicmem]+1.96*_se[phicmem] if bw==`b'
					replace ll_`yvar'=_b[phicmem]-1.96*_se[phicmem] if bw==`b'
				if inlist(`b',5,10) {
					global name apis`b'`yvar'
					qui est store $name
					qui estadd ysumm
					mat statsX = wordcount("`fX'") \ `e(ymean)' \ `=e(N)'
					mat stats = nullmat(stats), statsX 
				ivreg2 `yvar' (phicmem = D_after) D i.year c.(`fX') i.D#c.(`fX') flagexp /*flagmed*/ $controls if inrange(X1, -`b', `b'-1) , /*partial($controls)*/ cluster($cluster) 
					do "$code\boottest_output"
					global flist0 ${flist0} apis`b'`yvar'
		
				}
					
	} 
	
}
if "$extrabandwidths"!="" {
    preserve
	keep if b_lnpchealth<.
	foreach yvar in lnpchealth healthshare lnpcop lnpcip lnpcdrug {
		graph twoway (line b_`yvar' bw) (rcap ul_`yvar' ll_`yvar' bw), yline(0) legend(off) xtitle("Bandwidth") ytitle("Estimate") title("${title_`yvar'}")
		graph export "$figs\bw_`yvar'.png", as(png) width(2000) replace
	}
	restore
}

* Capture column-wise scalars

mat rowname stats = "Polynomial Order" "Mean of Dep. Var." "\$ N\$"

* Print table in latex 
local latex_opt_top  ///  
	prehead( ///
		"\begin{tabular}{l*{@M}{rr}}" ///
		"\hline" ///
		"\hline" ///
		) ///
	posthead( ///
		" & \multicolumn{2}{c}{\shortstack{Log Health\\Expenditures}} & \multicolumn{2}{c}{\shortstack{Health\\Expenditure Share}} & \multicolumn{2}{c}{\shortstack{Log Inpatient\\Expenditures}} &  \multicolumn{2}{c}{\shortstack{Log Outpatient\\Expenditures}}  & \multicolumn{2}{c}{\shortstack{Log Medical\\Product Exp.}}  \\" ///
		"Bandwidth & 5 & 10 & 5 & 10 & 5 & 10 & 5 & 10 & 5 & 10 \\" ///
		"\hline" ///
		"\hline" ///
		"& \multicolumn{@M}{c}{} \\" ///
		)
local latex_opt_end  ///
	prefoot( ///
		"\hline" ///
		) ///
	postfoot( ///
		"\hline" ///
		"\end{tabular}" ///
		)
local labopt_est  keep(phicmem) cells(b(fmt(a2)) se(star fmt(a2) par) boot_pval( fmt(2) par([ ]))) ///
   stats(widstat idstat, labels("{\footnotesize \hspace{5mm}Weak identification F}" "{\footnotesize \hspace{5mm}Underidentification F}")) collabels(none) varw(25) style(tex) 
local labopt_est0 mlabel(none) `latex_opt_top' replace 
local labopt_estX mlabel(none) append
local labopt_fin  mlabel(none) collabels(none) modelw(15) varw(25) style(tex) `latex_opt_end' append

estout $flist0 using "${texfile}_apis.tex", `labopt_est' `labopt_est0' varlabel(phicmem "Enrolled in PHIC") starlevels(* 0.1 ** 0.05 *** 0.01) 

estout matrix(stats, fmt(a2)) using "${texfile}_apis.tex", `labopt_fin' 

*
global flist0 
cap matrix drop stats
foreach yvar in   lnpchealth healthshare lnpcip lnpcop  lnpcdrug  {

	foreach b in  5 10 { 
	
		if `b' < 5 {
		local fX ${apisbw2}
		}
		
		if inrange(`b',5,9) {
		local fX ${apisbw5}			
		}
		if `b' >= 10 {
		local fX ${apisbw10}
		}	
		
				ivreg2 `yvar' (phicmem = D_after) D i.year c.(`fX') i.D#c.(`fX') $controls if inrange(X1, -`b', `b'-1) & flagexp==0 , partial($controls) cluster(hhid)
					global name apis`b'`yvar'
					qui est store $name
					qui estadd ysumm
					mat statsX = wordcount("`fX'") \ `e(ymean)' \ `=e(N)'
					mat stats = nullmat(stats), statsX
				ivreg2 `yvar' (phicmem = D_after) D i.year c.(`fX') i.D#c.(`fX') $controls if inrange(X1, -`b', `b'-1) & flagexp==0 , partial($controls) cluster($cluster)
					do "$code\boottest_output"
					global flist0 ${flist0} apis`b'`yvar'
 		
	} 
}



* Capture column-wise scalars

mat rowname stats = "Polynomial Order" "Mean of Dep. Var." "\$ N\$"
 

* Print table in latex 
local latex_opt_top  ///  
	prehead( ///
		"\begin{tabular}{l*{@M}{rr}}" ///
		"\hline" ///
		"\hline" ///
		) ///
	posthead( ///
		" & \multicolumn{2}{c}{\shortstack{Log Health\\Expenditures}} & \multicolumn{2}{c}{\shortstack{Health\\Expenditure Share}}  & \multicolumn{2}{c}{\shortstack{Log Inpatient\\Expenditures}}&  \multicolumn{2}{c}{\shortstack{Log Outpatient\\Expenditures}} & \multicolumn{2}{c}{\shortstack{Log Medical\\Product Exp.}}  \\" ///
		"Bandwidth & 5 & 10 & 5 & 10 & 5 & 10 & 5 & 10 & 5 & 10 \\" ///
		"\hline" ///
		"\hline" ///
		"& \multicolumn{@M}{c}{} \\" ///
		)
local latex_opt_end  ///
	prefoot( ///
		"\hline" ///
		) ///
	postfoot( ///
		"\hline" ///
		"\end{tabular}" ///
		)
local labopt_est  keep(phicmem) cells(b(fmt(a2)) se(star fmt(a2) par) boot_pval( fmt(2) par([ ]))) ///
   stats(widstat idstat, labels("{\footnotesize \hspace{5mm}Weak identification F}" "{\footnotesize \hspace{5mm}Underidentification F}")) collabels(none) varw(25) style(tex) 
local labopt_est0 mlabel(none) `latex_opt_top' replace 
local labopt_estX mlabel(none) append
local labopt_fin  mlabel(none) collabels(none) modelw(15) varw(25) style(tex) `latex_opt_end' append

estout $flist0 using "${texfile}_apisapp.tex", `labopt_est' `labopt_est0' varlabel(phicmem "Enrolled in PHIC") starlevels(* 0.1 ** 0.05 *** 0.01) 

estout matrix(stats, fmt(a2)) using "${texfile}_apisapp.tex", `labopt_fin' 

 */


 
*******************************************************************************
**DHS*************************************************************************
*******************************************************************************
   
global flist0 
cap matrix drop stats
use "$data\ndhsfile", clear
cap g bw=_n
foreach yvar in yconfined mvisit  mconfined {
	cap g b_`yvar'=.
	cap g ul_`yvar'=.
	cap g ll_`yvar'=.
	
	local blist "5,10"
	if "`yvar'"=="mconfined" {
		local blist "5, 10, 15"
	}
		
	local _blist=subinstr("`blist'",","," ",.)
	display "`_blist'" 
	
	foreach b in  `_blist' $extrabandwidths { 
	
	if `b' < 5 {
	local fX ${dhsbw2}
	}
	
	if inrange(`b',5,9) {
	local fX ${dhsbw5}			
	}
	if `b' >= 10 {
	local fX ${dhsbw10}
	}	
				qui ivreg2 `yvar' (phicmem = D_after) D yr c.(`fX') i.D#c.(`fX') $controls if inrange(X1, -`b', `b'-1), /*partial($controls)*/ cluster(hhid) 
					replace b_`yvar'=_b[phicmem] if bw==`b'
					replace ul_`yvar'=_b[phicmem]+1.96*_se[phicmem] if bw==`b'
					replace ll_`yvar'=_b[phicmem]-1.96*_se[phicmem] if bw==`b'
					
				if inlist(`b',`blist') {
					global name dhs`b'`yvar'
					qui est store $name
					qui estadd ysumm
					mat statsX = wordcount("`fX'") \ `e(ymean)' \ `=e(N)'
					mat stats = nullmat(stats), statsX 
				qui ivreg2 `yvar' (phicmem = D_after) D yr c.(`fX') i.D#c.(`fX') $controls if inrange(X1, -`b', `b'-1), /*partial($controls)*/ cluster($cluster) 
					do "$code\boottest_output"
					global flist0 ${flist0} dhs`b'`yvar'
	
				}
	} 
}
*yvar loop end

if "$extrabandwidths"!="" {
	keep if b_yconfined <.
	foreach yvar in yconfined mvisit  mconfined {
		graph twoway (line b_`yvar' bw) (rcap ul_`yvar' ll_`yvar' bw),   yline(0) legend(off) xtitle("Bandwidth") ytitle("Estimate") title("${title_`yvar'}")
		graph export "$figs\bw_`yvar'.png", as(png) width(2000) replace
	}
}

* Capture column-wise scalars

mat rowname stats = "Polynomial Order" "Mean of Dep. Var." "\$ N\$"

	
* Print table in latex 
local latex_opt_top  ///  
	prehead( ///
		"\begin{tabular}{l*{@M}{rr}}" ///
		"\hline" ///
		"\hline" ///
		) ///
	posthead( ///
		 "& \multicolumn{2}{c}{\shortstack{Hospital Stay\\Last Year}} & \multicolumn{2}{c}{\shortstack{Health Visit\\Last Month}} & \multicolumn{3}{c}{\shortstack{Hospital Stay\\Last Month}}  \\"		 ///
		"Bandwidth & 5 & 10 & 5 & 10 & 5 & 10 & 15 \\" ///
		"\hline" ///
		"\hline" ///
		"& \multicolumn{@M}{c}{} \\" ///
		)
local latex_opt_end  ///
	prefoot( ///
		"\hline" ///
		) ///
	postfoot( ///
		"\hline" ///
		"\end{tabular}" ///
		)
local labopt_est  keep(phicmem) cells(b(fmt(a2)) se(star fmt(a2) par) boot_pval( fmt(2) par([ ]))) ///
   stats(widstat idstat, labels("{\footnotesize \hspace{5mm}Weak identification F}" "{\footnotesize \hspace{5mm}Underidentification F}")) collabels(none) varw(25) style(tex) 
local labopt_est0 mlabel(none) `latex_opt_top' replace 
local labopt_estX mlabel(none) append
local labopt_fin  mlabel(none) collabels(none) modelw(15) varw(25) style(tex) `latex_opt_end' append

estout $flist0 using "${texfile}_dhs.tex", `labopt_est' `labopt_est0' varlabel(phicmem "Enrolled in PHIC") starlevels(* 0.1 ** 0.05 *** 0.01) 

estout matrix(stats, fmt(a2)) using "${texfile}_dhs.tex", `labopt_fin' 

